* Title: 	cdc_mortality_clean.do
* Version: 	23 May 2018
* Purpose: 	Clean mortality data from CDC

* Source: https://wonder.cdc.gov/mortSQL.html
* Date accessed: 23 May 2018

*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using log/cdc_mortality_clean, replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load and clean CDC WONDER data for prime-age men, 1968-2016
*******************************************************************************

foreach year in 1968_1978 1979_1998 1999_2016 {
	import delimited using dta/raw/cdc_mortality_`year'.txt, stringc(_all) clear
	
	drop notes yearcode cruderate
	drop if (year=="" | statecode == "")
	
	destring _all, replace
	tempfile `year'
	save ``year''
}

use `1968_1978', clear
append using `1979_1998'
append using `1999_2016'

* Merge with indicator for region
rename statecode statefip
merge m:1 statefip using dta/state_region, assert(matched) nogen

*******************************************************************************
* (2) End of file
*******************************************************************************

compress

save dta/cdc_mortality_clean, replace

log close
exit, clear
